/*
 * Decompiled with CFR 0.152.
 */
package com.example.clinic.service.impl;

import com.example.clinic.dto.Booking;
import com.example.clinic.dto.LabReportsDTO;
import com.example.clinic.dto.PatientMedicineDTO;
import com.example.clinic.dto.ServiceFilterDTO;
import com.example.clinic.dto.ServiceProviderDTO;
import com.example.clinic.model.Appointments;
import com.example.clinic.model.BookVisit;
import com.example.clinic.model.DoseTime;
import com.example.clinic.model.DoseTimeRenew;
import com.example.clinic.model.LabReports;
import com.example.clinic.model.PatientMedicine;
import com.example.clinic.model.RenewMedicine;
import com.example.clinic.model.Reports;
import com.example.clinic.model.Reviews;
import com.example.clinic.model.SavedMidicines;
import com.example.clinic.model.ServiceProfile;
import com.example.clinic.model.ServiceProviders;
import com.example.clinic.model.User;
import com.example.clinic.repository.PatientMedicineRepository;
import com.example.clinic.repository.UserRepository;
import com.example.clinic.service.PateintMedicineService;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;

@Service
public class PateintMedicineServiceImpl
implements PateintMedicineService {
    boolean correctNumber = false;
    @Autowired
    UserRepository userRepository;
    @Autowired
    PatientMedicineRepository patientMedicineRepository;

    public PatientMedicine addMedicine(PatientMedicineDTO patientMedicineDTO) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        String email = authentication.getName();
        User user = (User)this.userRepository.findByemailAddress(email).get();
        PatientMedicine patientMedicine = new PatientMedicine();
        RenewMedicine renewMedicine = new RenewMedicine();
        patientMedicine.setDescription(patientMedicineDTO.getDescription());
        patientMedicine.setDose(patientMedicineDTO.getDose());
        patientMedicine.setMedicineImage(patientMedicineDTO.getMedicineImage());
        patientMedicine.setMedicineName(patientMedicineDTO.getMedicineName());
        patientMedicine.setDoctorName(patientMedicineDTO.getDoctorName());
        patientMedicine.setCountOfDose(0.0);
        patientMedicine.setUserMedicine(user);
        patientMedicine.setStartFrom(patientMedicineDTO.getStartFrom());
        patientMedicine.setDoseDurationList(patientMedicineDTO.getDoseDurationList());
        patientMedicine.setDoseFrequency(patientMedicineDTO.getDoseFrequency());
        patientMedicine.setDoseDuration(patientMedicineDTO.getDoseDuration());
        patientMedicine.setDoseForm(patientMedicineDTO.getDoseForm());
        patientMedicine.setDoseRoute(patientMedicineDTO.getDoseRoute());
        int totalDose = 0;
        int totalDoseDurated = 0;
        if (patientMedicineDTO.getDoseFrequency().equalsIgnoreCase("weekly")) {
            totalDose = patientMedicineDTO.getDose() * patientMedicineDTO.getDoseDuration();
            totalDoseDurated = patientMedicineDTO.getDoseDuration() * 7;
        }
        if (patientMedicineDTO.getDoseFrequency().equalsIgnoreCase("weekly")) {
            totalDose = patientMedicineDTO.getDose() * patientMedicineDTO.getDoseDuration();
            totalDoseDurated = patientMedicineDTO.getDoseDuration() * 7;
        }
        if (patientMedicineDTO.getDoseFrequency().equalsIgnoreCase("monthly")) {
            totalDose = patientMedicineDTO.getDose() * patientMedicineDTO.getDoseDuration();
            totalDoseDurated = patientMedicineDTO.getDoseDuration() * 30;
        }
        if (patientMedicineDTO.getDoseFrequency().equalsIgnoreCase("weekly") && patientMedicineDTO.getDoseDurationList().equalsIgnoreCase("months")) {
            totalDose = patientMedicineDTO.getDose() * patientMedicineDTO.getDoseDuration() * 4;
            totalDoseDurated = patientMedicineDTO.getDoseDuration() * 4;
        }
        if (patientMedicineDTO.getDoseFrequency().equalsIgnoreCase("daily") && patientMedicineDTO.getDoseDurationList().equalsIgnoreCase("months")) {
            totalDose = patientMedicineDTO.getDose() * patientMedicineDTO.getDoseDuration() * 30;
            totalDoseDurated = patientMedicineDTO.getDoseDuration() * 30;
        }
        if (patientMedicineDTO.getDoseFrequency().equalsIgnoreCase("daily") && patientMedicineDTO.getDoseDurationList().equalsIgnoreCase("weeks")) {
            totalDose = patientMedicineDTO.getDose() * patientMedicineDTO.getDoseDuration() * 7;
            totalDoseDurated = patientMedicineDTO.getDoseDuration() * 7;
        }
        if (patientMedicineDTO.getDoseFrequency().equalsIgnoreCase("weekly") && patientMedicineDTO.getDoseDurationList().equalsIgnoreCase("days")) {
            totalDose = patientMedicineDTO.getDose() * patientMedicineDTO.getDoseDuration() * 7;
            totalDoseDurated = patientMedicineDTO.getDoseDuration() * 7;
        }
        if (patientMedicineDTO.getDoseFrequency().equalsIgnoreCase("monthly") && patientMedicineDTO.getDoseDurationList().equalsIgnoreCase("days")) {
            totalDose = patientMedicineDTO.getDose() * patientMedicineDTO.getDoseDuration() * 30;
            totalDoseDurated = patientMedicineDTO.getDoseDuration() * 30;
        }
        if (patientMedicineDTO.getDoseFrequency().equalsIgnoreCase("daily") && patientMedicineDTO.getDoseDurationList().equalsIgnoreCase("days")) {
            totalDose = patientMedicineDTO.getDose() * patientMedicineDTO.getDoseDuration();
            totalDoseDurated = patientMedicineDTO.getDoseDuration();
        }
        patientMedicine.setTotalDoses((double)totalDose);
        patientMedicine.setTotalDuration(totalDoseDurated);
        patientMedicine.setSpecialInstructions(patientMedicineDTO.getSpecialInstructions());
        patientMedicine.setRenewalDate(patientMedicineDTO.getRenewalDate());
        DoseTime doseTime = new DoseTime();
        DoseTimeRenew doseTimeRenew = new DoseTimeRenew();
        patientMedicine.setLeftDosesCount(totalDose);
        int compliance = patientMedicineDTO.getCountOfDose() / totalDose;
        patientMedicine.setDoseCompliance(String.valueOf(compliance *= 100) + " %");
        patientMedicine.setLeftDosesDaysCouns(totalDoseDurated);
        PatientMedicine patientMedicineSaved = this.patientMedicineRepository.addmedicine(patientMedicine);
        for (String result : patientMedicineDTO.getDoseTimeList()) {
            doseTime.setDoseTime(result);
            doseTime.setPatientMedicineTimes(patientMedicineSaved);
            this.patientMedicineRepository.saveTimes(doseTime);
        }
        renewMedicine.setId(patientMedicineSaved.getId());
        renewMedicine.setMedicineId(patientMedicineSaved.getId());
        renewMedicine.setDescription(patientMedicineDTO.getDescription());
        renewMedicine.setDose(patientMedicineDTO.getDose());
        renewMedicine.setMedicineImage(patientMedicineDTO.getMedicineImage());
        renewMedicine.setMedicineName(patientMedicineDTO.getMedicineName());
        renewMedicine.setDoctorName(patientMedicineDTO.getDoctorName());
        renewMedicine.setCountOfDose(0.0);
        renewMedicine.setUserMedicine(user);
        renewMedicine.setDoseDurationList(patientMedicineDTO.getDoseDurationList());
        renewMedicine.setDoseFrequency(patientMedicineDTO.getDoseFrequency());
        renewMedicine.setDoseDuration(patientMedicineDTO.getDoseDuration());
        renewMedicine.setDoseForm(patientMedicineDTO.getDoseForm());
        renewMedicine.setDoseRoute(patientMedicineDTO.getDoseRoute());
        renewMedicine.setStartFrom(patientMedicineDTO.getStartFrom());
        renewMedicine.setTotalDoses((double)totalDose);
        renewMedicine.setTotalDuration(totalDoseDurated);
        renewMedicine.setSpecialInstructions(patientMedicineDTO.getSpecialInstructions());
        renewMedicine.setRenewalDate(patientMedicineDTO.getRenewalDate());
        for (String result : patientMedicineDTO.getDoseTimeList()) {
            doseTimeRenew.setDoseTime(result);
            doseTimeRenew.setPatientMedicineTimesRen(patientMedicineSaved);
            this.patientMedicineRepository.saveTimesRenew(doseTimeRenew);
        }
        renewMedicine.setLeftDosesCount(totalDose);
        int complianceRenew = patientMedicineDTO.getCountOfDose() / totalDose;
        complianceRenew = compliance * 100;
        renewMedicine.setDoseCompliance(String.valueOf(complianceRenew) + " %");
        renewMedicine.setLeftDosesDaysCouns(totalDoseDurated);
        this.patientMedicineRepository.addmedicineRenew(renewMedicine);
        return patientMedicineSaved;
    }

    public PatientMedicine updateDoseCount(int id) {
        PatientMedicine patientMedicine = this.patientMedicineRepository.findMedicineByid(id);
        double doseCount = patientMedicine.getCountOfDose() + 1.0;
        patientMedicine.setCountOfDose(doseCount);
        double remainder = doseCount / (double)patientMedicine.getDose();
        boolean isWhole = remainder % 1.0 == 0.0;
        int daysLeftAfterDose = 0;
        daysLeftAfterDose = isWhole && doseCount != 1.0 ? patientMedicine.getLeftDosesDaysCouns() - 1 : patientMedicine.getLeftDosesDaysCouns();
        patientMedicine.setLeftDosesDaysCouns(daysLeftAfterDose);
        int leftDoses = patientMedicine.getLeftDosesCount() - 1;
        patientMedicine.setLeftDosesCount(leftDoses);
        double totalDoses = patientMedicine.getTotalDoses() - 1.0;
        patientMedicine.setTotalDoses(totalDoses);
        double compliance = doseCount / totalDoses;
        compliance *= 100.0;
        compliance = Math.round(compliance);
        patientMedicine.setDoseCompliance(String.valueOf(compliance) + " %");
        return this.patientMedicineRepository.addmedicine(patientMedicine);
    }

    public List<PatientMedicine> getMedicinList() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        String userName = authentication.getName();
        User user = (User)this.userRepository.findByemailAddress(userName).get();
        return this.patientMedicineRepository.getMedicinesByUserId(user.getId());
    }

    public PatientMedicine getMedicineDetails(int id) {
        return this.patientMedicineRepository.getMedicineById(id);
    }

    public void deleteMedicine(int id) {
        this.patientMedicineRepository.deleteMedicine(id);
    }

    public void renewMedicine(int id) {
        RenewMedicine patientMedicineDTO = this.patientMedicineRepository.getMedicineFromRenew(id);
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        String userName = authentication.getName();
        User user = (User)this.userRepository.findByemailAddress(userName).get();
        PatientMedicine patientMedicine = new PatientMedicine();
        patientMedicine.setDescription(patientMedicineDTO.getDescription());
        patientMedicine.setDose(patientMedicineDTO.getDose());
        patientMedicine.setMedicineImage(patientMedicineDTO.getMedicineImage());
        patientMedicine.setMedicineName(patientMedicineDTO.getMedicineName());
        patientMedicine.setDoctorName(patientMedicineDTO.getDoctorName());
        patientMedicine.setCountOfDose(0.0);
        patientMedicine.setUserMedicine(user);
        patientMedicine.setStartFrom(patientMedicineDTO.getStartFrom());
        patientMedicine.setDoseFrequency(patientMedicineDTO.getDoseFrequency());
        patientMedicine.setDoseDuration(patientMedicineDTO.getDoseDuration());
        patientMedicine.setDoseForm(patientMedicineDTO.getDoseForm());
        patientMedicine.setDoseRoute(patientMedicineDTO.getDoseRoute());
        int totalDose = 0;
        int totalDoseDurated = 0;
        if (patientMedicineDTO.getDoseFrequency().equalsIgnoreCase("weekly")) {
            totalDose = patientMedicineDTO.getDose() * patientMedicineDTO.getDoseDuration();
            totalDoseDurated = patientMedicineDTO.getDoseDuration() * 7;
        }
        if (patientMedicineDTO.getDoseFrequency().equalsIgnoreCase("monthly")) {
            totalDose = patientMedicineDTO.getDose() * patientMedicineDTO.getDoseDuration();
            totalDoseDurated = patientMedicineDTO.getDoseDuration() * 30;
        }
        if (patientMedicineDTO.getDoseFrequency().equalsIgnoreCase("daily") && patientMedicineDTO.getDoseDurationList().equalsIgnoreCase("months")) {
            totalDose = patientMedicineDTO.getDose() * patientMedicineDTO.getDoseDuration() * 30;
            totalDoseDurated = patientMedicineDTO.getDoseDuration() * 30;
        }
        if (patientMedicineDTO.getDoseFrequency().equalsIgnoreCase("daily") && patientMedicineDTO.getDoseDurationList().equalsIgnoreCase("weeks")) {
            totalDose = patientMedicineDTO.getDose() * patientMedicineDTO.getDoseDuration() * 7;
            totalDoseDurated = patientMedicineDTO.getDoseDuration() * 7;
        }
        if (patientMedicineDTO.getDoseFrequency().equalsIgnoreCase("weekly") && patientMedicineDTO.getDoseDurationList().equalsIgnoreCase("days")) {
            totalDose = patientMedicineDTO.getDose() * patientMedicineDTO.getDoseDuration() * 7;
            totalDoseDurated = patientMedicineDTO.getDoseDuration() * 7;
        }
        if (patientMedicineDTO.getDoseFrequency().equalsIgnoreCase("monthly") && patientMedicineDTO.getDoseDurationList().equalsIgnoreCase("days")) {
            totalDose = patientMedicineDTO.getDose() * patientMedicineDTO.getDoseDuration() * 30;
            totalDoseDurated = patientMedicineDTO.getDoseDuration() * 30;
        }
        if (patientMedicineDTO.getDoseFrequency().equalsIgnoreCase("daily") && patientMedicineDTO.getDoseDurationList().equalsIgnoreCase("days")) {
            totalDose = patientMedicineDTO.getDose() * patientMedicineDTO.getDoseDuration();
            totalDoseDurated = patientMedicineDTO.getDoseDuration();
        }
        patientMedicine.setTotalDoses((double)totalDose);
        patientMedicine.setTotalDuration(totalDoseDurated);
        patientMedicine.setSpecialInstructions(patientMedicineDTO.getSpecialInstructions());
        patientMedicine.setRenewalDate(patientMedicineDTO.getRenewalDate());
        patientMedicine.setDoseTimeList(patientMedicineDTO.getDoseTimeList());
        patientMedicine.setLeftDosesCount(totalDose);
        double compliance = patientMedicineDTO.getCountOfDose() / (double)totalDose;
        patientMedicine.setDoseCompliance(String.valueOf(compliance *= 100.0) + " %");
        patientMedicine.setLeftDosesDaysCouns(totalDoseDurated);
        this.patientMedicineRepository.deleteMedicine(id);
        PatientMedicine p = this.patientMedicineRepository.addmedicine(patientMedicine);
        patientMedicineDTO.setMedicineId(p.getId());
        this.patientMedicineRepository.addmedicineRenew(patientMedicineDTO);
    }

    public void updateMedicine(int id, PatientMedicineDTO patientMedicineDTO) {
        ArrayList<DoseTime> doseTimeList;
        DoseTime doseTime;
        PatientMedicine patientMedicine = this.patientMedicineRepository.findMedicineByid(id);
        if (patientMedicineDTO.getDescription() != null) {
            patientMedicine.setDescription(patientMedicineDTO.getDescription());
        }
        if (patientMedicineDTO.getDose() != 0) {
            patientMedicine.setDose(patientMedicineDTO.getDose());
        }
        if (patientMedicineDTO.getMedicineImage() != null) {
            patientMedicine.setMedicineImage(patientMedicineDTO.getMedicineImage());
        }
        if (patientMedicineDTO.getMedicineName() != null) {
            patientMedicine.setMedicineName(patientMedicineDTO.getMedicineName());
        }
        if (patientMedicineDTO.getDoctorName() != null) {
            patientMedicine.setDoctorName(patientMedicineDTO.getDoctorName());
        }
        if (patientMedicineDTO.getDoseFrequency() != null) {
            patientMedicine.setDoseFrequency(patientMedicineDTO.getDoseFrequency());
        }
        if (patientMedicineDTO.getDoseDuration() != 0) {
            patientMedicine.setDoseDuration(patientMedicineDTO.getDoseDuration());
        }
        if (patientMedicineDTO.getDoseRoute() != null) {
            patientMedicine.setDoseRoute(patientMedicineDTO.getDoseRoute());
        }
        if (patientMedicineDTO.getDoseForm() != null) {
            patientMedicine.setDoseForm(patientMedicineDTO.getDoseForm());
        }
        if (patientMedicineDTO.getSpecialInstructions() != null) {
            patientMedicine.setSpecialInstructions(patientMedicineDTO.getSpecialInstructions());
        }
        if (patientMedicineDTO.getRenewalDate() != null) {
            patientMedicine.setRenewalDate(patientMedicineDTO.getRenewalDate());
        }
        if (patientMedicineDTO.getDoseTimeList() != null) {
            DoseTime doseTime2 = new DoseTime();
            ArrayList<DoseTime> doseTimeList2 = new ArrayList<DoseTime>();
            for (String result : patientMedicineDTO.getDoseTimeList()) {
                doseTime2.setPatientMedicineTimes(patientMedicine);
                doseTime2.setDoseTime(result);
                doseTimeList2.add(doseTime2);
            }
            patientMedicine.setDoseTimeList(doseTimeList2);
        }
        if (patientMedicineDTO.getDoseDurationList() != null) {
            patientMedicine.setDoseDurationList(patientMedicineDTO.getDoseDurationList());
        }
        int compliance = 0;
        int totalDose = 0;
        int totalDoseDurated = 0;
        if (patientMedicineDTO.getDoseDuration() != 0 && patientMedicineDTO.getDose() != 0) {
            if (patientMedicineDTO.getDoseFrequency().equalsIgnoreCase("weekly") && !patientMedicineDTO.getDoseDurationList().equalsIgnoreCase("days")) {
                totalDose = patientMedicineDTO.getDose() * patientMedicineDTO.getDoseDuration();
                totalDoseDurated = patientMedicineDTO.getDoseDuration() * 7;
            }
            if (patientMedicineDTO.getDoseFrequency().equalsIgnoreCase("monthly") && !patientMedicineDTO.getDoseDurationList().equalsIgnoreCase("days")) {
                totalDose = patientMedicineDTO.getDose() * patientMedicineDTO.getDoseDuration();
                totalDoseDurated = patientMedicineDTO.getDoseDuration() * 30;
            }
            if (patientMedicineDTO.getDoseFrequency().equalsIgnoreCase("daily") && patientMedicineDTO.getDoseDurationList().equalsIgnoreCase("months")) {
                totalDose = patientMedicineDTO.getDose() * patientMedicineDTO.getDoseDuration() * 30;
                totalDoseDurated = patientMedicineDTO.getDoseDuration() * 30;
            }
            if (patientMedicineDTO.getDoseFrequency().equalsIgnoreCase("daily") && patientMedicineDTO.getDoseDurationList().equalsIgnoreCase("weeks")) {
                totalDose = patientMedicineDTO.getDose() * patientMedicineDTO.getDoseDuration() * 7;
                totalDoseDurated = patientMedicineDTO.getDoseDuration() * 7;
            }
            if (patientMedicineDTO.getDoseFrequency().equalsIgnoreCase("weekly") && patientMedicineDTO.getDoseDurationList().equalsIgnoreCase("days")) {
                totalDose = patientMedicineDTO.getDose() * patientMedicineDTO.getDoseDuration() * 7;
                totalDoseDurated = patientMedicineDTO.getDoseDuration() * 7;
            }
            if (patientMedicineDTO.getDoseFrequency().equalsIgnoreCase("monthly") && patientMedicineDTO.getDoseDurationList().equalsIgnoreCase("days")) {
                totalDose = patientMedicineDTO.getDose() * patientMedicineDTO.getDoseDuration() * 30;
                totalDoseDurated = patientMedicineDTO.getDoseDuration() * 30;
            }
            if (patientMedicineDTO.getDoseFrequency().equalsIgnoreCase("daily") && patientMedicineDTO.getDoseDurationList().equalsIgnoreCase("days")) {
                totalDose = patientMedicineDTO.getDose() * patientMedicineDTO.getDoseDuration();
                totalDoseDurated = patientMedicineDTO.getDoseDuration();
            }
            patientMedicine.setLeftDosesDaysCouns(totalDoseDurated);
            patientMedicine.setTotalDoses((double)totalDose);
            compliance = patientMedicineDTO.getCountOfDose() / totalDose;
            patientMedicine.setDoseCompliance(String.valueOf(compliance *= 100) + " %");
            patientMedicine.setLeftDosesCount(totalDose);
            patientMedicine.setTotalDuration(totalDoseDurated);
        }
        PatientMedicine p = this.patientMedicineRepository.addmedicine(patientMedicine);
        RenewMedicine renewMedicine = this.patientMedicineRepository.getMedicineFromRenew(id);
        if (patientMedicineDTO.getDescription() != null) {
            renewMedicine.setDescription(patientMedicineDTO.getDescription());
        }
        if (patientMedicineDTO.getDose() != 0) {
            renewMedicine.setDose(patientMedicineDTO.getDose());
        }
        if (patientMedicineDTO.getMedicineImage() != null) {
            renewMedicine.setMedicineImage(patientMedicineDTO.getMedicineImage());
        }
        if (patientMedicineDTO.getMedicineName() != null) {
            renewMedicine.setMedicineName(patientMedicineDTO.getMedicineName());
        }
        if (patientMedicineDTO.getDoctorName() != null) {
            renewMedicine.setDoctorName(patientMedicineDTO.getDoctorName());
        }
        if (patientMedicineDTO.getDoseFrequency() != null) {
            renewMedicine.setDoseFrequency(patientMedicineDTO.getDoseFrequency());
        }
        if (patientMedicineDTO.getDoseDuration() != 0) {
            renewMedicine.setDoseDuration(patientMedicineDTO.getDoseDuration());
        }
        if (patientMedicineDTO.getDoseRoute() != null) {
            renewMedicine.setDoseRoute(patientMedicineDTO.getDoseRoute());
        }
        if (patientMedicineDTO.getDoseForm() != null) {
            renewMedicine.setDoseForm(patientMedicineDTO.getDoseForm());
        }
        if (patientMedicineDTO.getSpecialInstructions() != null) {
            renewMedicine.setSpecialInstructions(patientMedicineDTO.getSpecialInstructions());
        }
        if (patientMedicineDTO.getRenewalDate() != null) {
            renewMedicine.setRenewalDate(patientMedicineDTO.getRenewalDate());
        }
        if (patientMedicineDTO.getDoseTimeList() != null) {
            doseTime = new DoseTime();
            doseTimeList = new ArrayList<DoseTime>();
            for (String result : patientMedicineDTO.getDoseTimeList()) {
                doseTime.setPatientMedicineTimes(patientMedicine);
                doseTime.setDoseTime(result);
                doseTimeList.add(doseTime);
            }
            renewMedicine.setDoseTimeList(doseTimeList);
        }
        if (patientMedicineDTO.getSpecialInstructions() != null) {
            renewMedicine.setSpecialInstructions(patientMedicineDTO.getSpecialInstructions());
        }
        if (patientMedicineDTO.getRenewalDate() != null) {
            renewMedicine.setRenewalDate(patientMedicineDTO.getRenewalDate());
        }
        if (patientMedicineDTO.getDoseTimeList() != null) {
            doseTime = new DoseTime();
            doseTimeList = new ArrayList();
            for (String result : patientMedicineDTO.getDoseTimeList()) {
                doseTime.setPatientMedicineTimes(patientMedicine);
                doseTime.setDoseTime(result);
                doseTimeList.add(doseTime);
            }
            renewMedicine.setDoseTimeList(doseTimeList);
        }
        if (patientMedicineDTO.getDoseDurationList() != null) {
            renewMedicine.setDoseDurationList(patientMedicineDTO.getDoseDurationList());
        }
        if (patientMedicineDTO.getDose() != 0 && patientMedicineDTO.getDoseDuration() != 0) {
            renewMedicine.setLeftDosesCount(totalDose);
            renewMedicine.setTotalDoses((double)totalDose);
            renewMedicine.setTotalDuration(totalDoseDurated);
            renewMedicine.setDoseCompliance(String.valueOf(compliance) + " %");
            renewMedicine.setLeftDosesDaysCouns(totalDoseDurated);
        }
        this.patientMedicineRepository.addmedicineRenew(renewMedicine);
    }

    public List<SavedMidicines> getMedicinListSaved() {
        return this.patientMedicineRepository.savedMidicenes();
    }

    public List<SavedMidicines> getMedicinListSavedByname(String name) {
        return this.patientMedicineRepository.savedMidicenesByName(name);
    }

    public void addLabReport(LabReportsDTO labReportsList) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        User user = (User)this.userRepository.findByemailAddress(authentication.getName()).get();
        LabReports labReports = new LabReports();
        ArrayList<Reports> repotrdts = new ArrayList<Reports>();
        Reports r = new Reports();
        labReports.setLabType(labReportsList.getLabType());
        labReports.setUserReport(user);
        labReports.setDate(LocalDate.now());
        LabReports lReports = this.patientMedicineRepository.addReport(labReports);
        if (!labReportsList.getReport().isEmpty()) {
            for (byte[] result : labReportsList.getReport()) {
                r.setImgs(result);
                r.setUserId(user.getId());
                r.setLabReports(lReports);
                repotrdts.add(r);
            }
        }
        LabReports ts = this.patientMedicineRepository.getReportsByID(lReports.getId());
        ts.setReports(repotrdts);
        this.patientMedicineRepository.addReport(ts);
    }

    public void deleteReport(int reportId) {
        this.patientMedicineRepository.deleteLabReport(reportId);
    }

    public List<LabReports> filterLabs(LabReportsDTO labReportsDTO) {
        LocalDate localDate;
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        User user = this.userRepository.getUserByEmail(authentication.getName());
        ArrayList<LabReports> labReports = new ArrayList<LabReports>();
        if (labReportsDTO.getLabType() != null && labReportsDTO.getDateFrom() == null && labReportsDTO.getDateTo() == null) {
            labReports.addAll(this.patientMedicineRepository.getReportByLabType(labReportsDTO.getLabType(), user.getId()));
        }
        if (labReportsDTO.getDateTo() != null && labReportsDTO.getDateFrom() != null && labReportsDTO.getLabType() == null) {
            localDate = LocalDate.parse(labReportsDTO.getDateTo());
            labReports.addAll(this.patientMedicineRepository.getByDateFromTo(localDate, LocalDate.parse(labReportsDTO.getDateFrom()), user.getId()));
        }
        if (labReportsDTO.getDateTo() != null && labReportsDTO.getDateFrom() != null && labReportsDTO.getLabType() != null) {
            localDate = LocalDate.parse(labReportsDTO.getDateTo());
            labReports.addAll(this.patientMedicineRepository.getByLAbALL(labReportsDTO.getLabType(), localDate, LocalDate.parse(labReportsDTO.getDateFrom()), user.getId()));
        }
        return labReports;
    }

    public List<ServiceProviders> getServiceProviders() {
        return this.patientMedicineRepository.getServiceProviders();
    }

    public List<ServiceProviders> searchForProvider(ServiceProviderDTO serviceProviderDTO) {
        ArrayList<ServiceProviders> list = new ArrayList<ServiceProviders>();
        if (serviceProviderDTO.getProviderName() != null && serviceProviderDTO.getProviderType() != null) {
            list.addAll(this.patientMedicineRepository.getServiceProvidersByTypeAndName(serviceProviderDTO.getProviderName(), serviceProviderDTO.getProviderType()));
        }
        if (serviceProviderDTO.getProviderName() != null && serviceProviderDTO.getProviderType() == null) {
            list.addAll(this.patientMedicineRepository.getServiceProvidersByName(serviceProviderDTO.getProviderName()));
        }
        if (serviceProviderDTO.getProviderType() != null && serviceProviderDTO.getProviderName() == null) {
            list.addAll(this.patientMedicineRepository.getServiceProvidersByType(serviceProviderDTO.getProviderType()));
        }
        return list;
    }

    public List<ServiceProviders> getServiceProvidersByType(String type) {
        return this.patientMedicineRepository.getServiceProviderByType(type);
    }

    public ServiceProfile getDoctorProfile(int doctorId) {
        return this.patientMedicineRepository.getDoctorProfile(doctorId);
    }

    public List<LabReports> getReportsByUserId() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        User user = this.userRepository.getUserByEmail(authentication.getName());
        return this.patientMedicineRepository.getReportsByUSerID(user.getId());
    }

    public void addReviews(int doctorId, String review) {
        Reviews reviews = new Reviews();
        ServiceProfile serviceProfile = this.patientMedicineRepository.getDoctorProfile(doctorId);
        reviews.setReview(review);
        reviews.setDoctorReviews(serviceProfile);
        this.patientMedicineRepository.addReview(reviews);
    }

    public ServiceProfile getProvidersReviews(int doctorId) {
        ServiceProfile serviceProfile = this.patientMedicineRepository.getDoctorProfile(doctorId);
        return serviceProfile;
    }

    public ServiceProfile bookAppointment(int doctorId, Booking book) {
        ServiceProfile serviceProfile = this.patientMedicineRepository.getDoctorProfile(doctorId);
        Appointments appointments = new Appointments();
        appointments.setServiceAppointment(serviceProfile);
        appointments.setAppointmentDay(book.getDay());
        appointments.setAppointmentTime(book.getTime());
        appointments.setCost(book.getCost());
        return serviceProfile;
    }

    public ServiceProfile bookHomeVisit(int doctorId, Booking book) {
        ServiceProfile serviceProfile = this.patientMedicineRepository.getDoctorProfile(doctorId);
        BookVisit bookVisit = new BookVisit();
        bookVisit.setVisitRegion(book.getRegion());
        bookVisit.setVisitCity(book.getCity());
        bookVisit.setVisitTime(book.getTime());
        bookVisit.setProfission(book.getProfission());
        bookVisit.setVisitCost(book.getCost());
        bookVisit.setServiceVisit(serviceProfile);
        return serviceProfile;
    }

    public List<ServiceProviders> FilterServiceProvider(String serviceType, ServiceFilterDTO serviceFilterDTO) {
        ArrayList<ServiceProviders> serviceProviders = new ArrayList<ServiceProviders>();
        if (serviceType.equalsIgnoreCase("nurse")) {
            if (serviceFilterDTO.getCity() != null) {
                serviceProviders.addAll(this.patientMedicineRepository.getServiceNurseBYcity(serviceType, serviceFilterDTO.getCity()));
            }
            if (serviceFilterDTO.getCountry() != null) {
                serviceProviders.addAll(this.patientMedicineRepository.getServiceNurseBYCountry(serviceType, serviceFilterDTO.getCity()));
            }
            if (serviceFilterDTO.getCost() != null && serviceFilterDTO.getCostTo() != null) {
                serviceProviders.addAll(this.patientMedicineRepository.getServiceNurseBYCost(serviceType, serviceFilterDTO.getCost(), serviceFilterDTO.getCostTo()));
            }
            if (serviceFilterDTO.getNurseName() != null) {
                serviceProviders.addAll(this.patientMedicineRepository.getServiceNurseBYNurseName(serviceType, serviceFilterDTO.getNurseName()));
            }
            if (serviceFilterDTO.getRate() != 0) {
                serviceProviders.addAll(this.patientMedicineRepository.getServiceNurseBYRate(serviceType, serviceFilterDTO.getRate()));
            }
        }
        if (serviceType.equalsIgnoreCase("doctor")) {
            if (serviceFilterDTO.getCity() != null) {
                serviceProviders.addAll(this.patientMedicineRepository.getServiceNurseBYcity(serviceType, serviceFilterDTO.getCity()));
            }
            if (serviceFilterDTO.getCountry() != null) {
                serviceProviders.addAll(this.patientMedicineRepository.getServiceNurseBYCountry(serviceType, serviceFilterDTO.getCity()));
            }
            if (serviceFilterDTO.getCost() != null && serviceFilterDTO.getCostTo() != null) {
                serviceProviders.addAll(this.patientMedicineRepository.getServiceNurseBYCost(serviceType, serviceFilterDTO.getCost(), serviceFilterDTO.getCostTo()));
            }
            if (serviceFilterDTO.getDoctorName() != null) {
                serviceProviders.addAll(this.patientMedicineRepository.getServiceBYDoctorName(serviceType, serviceFilterDTO.getDoctorName()));
            }
            if (serviceFilterDTO.getRate() != 0) {
                serviceProviders.addAll(this.patientMedicineRepository.getServiceNurseBYRate(serviceType, serviceFilterDTO.getRate()));
            }
        }
        if (serviceType.equalsIgnoreCase("rehab")) {
            if (serviceFilterDTO.getCity() != null) {
                serviceProviders.addAll(this.patientMedicineRepository.getServiceNurseBYcity(serviceType, serviceFilterDTO.getCity()));
            }
            if (serviceFilterDTO.getCountry() != null) {
                serviceProviders.addAll(this.patientMedicineRepository.getServiceNurseBYCountry(serviceType, serviceFilterDTO.getCity()));
            }
            if (serviceFilterDTO.getCost() != null && serviceFilterDTO.getCostTo() != null) {
                serviceProviders.addAll(this.patientMedicineRepository.getServiceNurseBYCost(serviceType, serviceFilterDTO.getCost(), serviceFilterDTO.getCostTo()));
            }
            if (serviceFilterDTO.getRate() != 0) {
                serviceProviders.addAll(this.patientMedicineRepository.getServiceNurseBYRate(serviceType, serviceFilterDTO.getRate()));
            }
        }
        if (serviceType.equalsIgnoreCase("hospital")) {
            if (serviceFilterDTO.getCity() != null) {
                serviceProviders.addAll(this.patientMedicineRepository.getServiceNurseBYcity(serviceType, serviceFilterDTO.getCity()));
            }
            if (serviceFilterDTO.getCountry() != null) {
                serviceProviders.addAll(this.patientMedicineRepository.getServiceNurseBYCountry(serviceType, serviceFilterDTO.getCity()));
            }
            if (serviceFilterDTO.getCost() != null && serviceFilterDTO.getCostTo() != null) {
                serviceProviders.addAll(this.patientMedicineRepository.getServiceNurseBYCost(serviceType, serviceFilterDTO.getCost(), serviceFilterDTO.getCostTo()));
            }
            if (serviceFilterDTO.getRate() != 0) {
                serviceProviders.addAll(this.patientMedicineRepository.getServiceNurseBYRate(serviceType, serviceFilterDTO.getRate()));
            }
        }
        if (serviceType.equalsIgnoreCase("labs")) {
            if (serviceFilterDTO.getCity() != null) {
                serviceProviders.addAll(this.patientMedicineRepository.getServiceNurseBYcity(serviceType, serviceFilterDTO.getCity()));
            }
            if (serviceFilterDTO.getCountry() != null) {
                serviceProviders.addAll(this.patientMedicineRepository.getServiceNurseBYCountry(serviceType, serviceFilterDTO.getCity()));
            }
            if (serviceFilterDTO.getCost() != null && serviceFilterDTO.getCostTo() != null) {
                serviceProviders.addAll(this.patientMedicineRepository.getServiceNurseBYCost(serviceType, serviceFilterDTO.getCost(), serviceFilterDTO.getCostTo()));
            }
            if (serviceFilterDTO.getRate() != 0) {
                serviceProviders.addAll(this.patientMedicineRepository.getServiceNurseBYRate(serviceType, serviceFilterDTO.getRate()));
            }
        }
        if (serviceType.equalsIgnoreCase("imagingCenter")) {
            if (serviceFilterDTO.getCity() != null) {
                serviceProviders.addAll(this.patientMedicineRepository.getServiceNurseBYcity(serviceType, serviceFilterDTO.getCity()));
            }
            if (serviceFilterDTO.getCountry() != null) {
                serviceProviders.addAll(this.patientMedicineRepository.getServiceNurseBYCountry(serviceType, serviceFilterDTO.getCity()));
            }
            if (serviceFilterDTO.getCost() != null && serviceFilterDTO.getCostTo() != null) {
                serviceProviders.addAll(this.patientMedicineRepository.getServiceNurseBYCost(serviceType, serviceFilterDTO.getCost(), serviceFilterDTO.getCostTo()));
            }
            if (serviceFilterDTO.getRate() != 0) {
                serviceProviders.addAll(this.patientMedicineRepository.getServiceNurseBYRate(serviceType, serviceFilterDTO.getRate()));
            }
        }
        return serviceProviders;
    }
}

