/*
 * Decompiled with CFR 0.152.
 */
package com.example.clinic.repository.impl;

import com.example.clinic.model.DiagnosesPrimrary;
import com.example.clinic.model.DiagnosesSecondry;
import com.example.clinic.model.NurseNames;
import com.example.clinic.model.OTPValidation;
import com.example.clinic.model.OnBoarding;
import com.example.clinic.model.PhysicianTeam;
import com.example.clinic.model.Teritiary;
import com.example.clinic.model.User;
import com.example.clinic.model.UserSession;
import com.example.clinic.repository.UserRepository;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.transaction.Transactional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.web.server.ResponseStatusException;

@Transactional
@Service
public class UserRepositoryImpl
implements UserRepository {
    @Autowired
    EntityManager em;

    public Optional<User> findByUsername(String username) {
        TypedQuery query = this.em.createQuery("from User where emailAddress = :userName ", User.class);
        query.setParameter("userName", (Object)username);
        List test = query.getResultList();
        if (!test.isEmpty()) {
            return Optional.ofNullable((User)test.get(0));
        }
        return Optional.empty();
    }

    public Optional<UserSession> gettokenByUserName(String username) {
        try {
            TypedQuery query = this.em.createQuery("from UserSession where token = :userName ", UserSession.class);
            query.setParameter("userName", (Object)username);
            List test = query.getResultList();
            if (!test.isEmpty()) {
                return Optional.ofNullable((UserSession)test.get(0));
            }
            return Optional.empty();
        }
        catch (DataAccessException e) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, "User Not Found");
        }
    }

    public Optional<User> findByemailAddress(String email) {
        TypedQuery query = this.em.createQuery("from User where emailAddress = :email ", User.class);
        query.setParameter("email", (Object)email);
        List test = query.getResultList();
        if (!test.isEmpty()) {
            return Optional.ofNullable((User)test.get(0));
        }
        return Optional.empty();
    }

    public Optional<User> findById(int userId) {
        TypedQuery query = this.em.createQuery("from User where id = :userId ", User.class);
        query.setParameter("userId", (Object)userId);
        List test = query.getResultList();
        if (!test.isEmpty()) {
            return Optional.ofNullable((User)test.get(0));
        }
        return Optional.empty();
    }

    public User registerUser(User user) {
        return (User)this.em.merge((Object)user);
    }

    public List<OnBoarding> getOnboardingView() {
        TypedQuery query = this.em.createQuery("from OnBoarding", OnBoarding.class);
        return query.getResultList();
    }

    public Optional<OTPValidation> getOtpByEmail(String emailAddress) {
        TypedQuery query = this.em.createQuery("from OTPValidation where emailAddress = :emailAddress", OTPValidation.class);
        query.setParameter("emailAddress", (Object)emailAddress);
        List test = query.getResultList();
        if (!test.isEmpty()) {
            return Optional.ofNullable((OTPValidation)test.get(0));
        }
        return Optional.empty();
    }

    public void saveEdittedUser(User user) {
        this.em.persist((Object)user);
    }

    public void deleteValidatedOTP(String email) {
        Query query = this.em.createQuery("delete from  OTPValidation where emailAddress = :emailAddress ");
        query.setParameter("emailAddress", (Object)email);
        query.executeUpdate();
    }

    public void deleteToken(String email) {
        Query query = this.em.createQuery("delete from  UserSession where emailAddress = :emailAddress ");
        query.setParameter("emailAddress", (Object)email);
        query.executeUpdate();
    }

    public Optional<User> getUserByPhone(String phoneNumber) {
        TypedQuery query = this.em.createQuery("from User where telephoneNumber = :userId ", User.class);
        query.setParameter("userId", (Object)phoneNumber);
        List test = query.getResultList();
        if (!test.isEmpty()) {
            return Optional.ofNullable((User)test.get(0));
        }
        return Optional.empty();
    }

    public void addPrimary(DiagnosesPrimrary diagnosesPrimraries) {
        this.em.merge((Object)diagnosesPrimraries);
    }

    public void nurseName(NurseNames nurseNamesList) {
        this.em.merge((Object)nurseNamesList);
    }

    public void tretaty(Teritiary teritiaryList) {
        this.em.merge((Object)teritiaryList);
    }

    public void team(PhysicianTeam physicianTeamList) {
        this.em.merge((Object)physicianTeamList);
    }

    public void secondaryDiag(DiagnosesSecondry diagnosesSecondries) {
        this.em.merge((Object)diagnosesSecondries);
    }

    public void deleteprimarydig(int id) {
        Query query = this.em.createQuery("delete from  DiagnosesPrimrary d where d.userPrimaryDiagnose.id = :emailAddress ");
        query.setParameter("emailAddress", (Object)id);
        query.executeUpdate();
    }

    public void deltenurse(int id) {
        Query query = this.em.createQuery("delete from  NurseNames ns where ns.userNurse.id = :emailAddress ");
        query.setParameter("emailAddress", (Object)id);
        query.executeUpdate();
    }

    public void deletesec(int id) {
        Query query = this.em.createQuery("delete from  DiagnosesSecondry ds where ds.secondaryDiagnoseUser.id = :emailAddress ");
        query.setParameter("emailAddress", (Object)id);
        query.executeUpdate();
    }

    public void deleteter(int id) {
        Query query = this.em.createQuery("delete from  Teritiary t where t.teritarty.id = :emailAddress ");
        query.setParameter("emailAddress", (Object)id);
        query.executeUpdate();
    }

    public void deleteteam(int id) {
        Query query = this.em.createQuery("delete from  PhysicianTeam p where p.userTeam.id = :emailAddress ");
        query.setParameter("emailAddress", (Object)id);
        query.executeUpdate();
    }

    public User getUserByEmail(String email) {
        TypedQuery query = this.em.createQuery("from User where emailAddress = :userId ", User.class);
        query.setParameter("userId", (Object)email);
        return (User)query.getSingleResult();
    }

    public Optional<NurseNames> findNurseByUserId(int id) {
        TypedQuery query = this.em.createQuery("from NurseNames ns where ns.userNurse.id = :userId ", NurseNames.class);
        query.setParameter("userId", (Object)id);
        ArrayList nurseNamesList = new ArrayList();
        nurseNamesList.addAll(query.getResultList());
        if (!nurseNamesList.isEmpty()) {
            return Optional.ofNullable((NurseNames)nurseNamesList.get(0));
        }
        return Optional.empty();
    }

    public Optional<PhysicianTeam> findteamByUserId(int id) {
        TypedQuery query = this.em.createQuery("from PhysicianTeam ns where ns.userTeam.id = :userId ", PhysicianTeam.class);
        query.setParameter("userId", (Object)id);
        ArrayList nurseNamesList = new ArrayList();
        nurseNamesList.addAll(query.getResultList());
        if (!nurseNamesList.isEmpty()) {
            return Optional.ofNullable((PhysicianTeam)nurseNamesList.get(0));
        }
        return Optional.empty();
    }

    public void savePhysican(PhysicianTeam physicianTeamList) {
        this.em.merge((Object)physicianTeamList);
    }

    public void savenurse(NurseNames nurseNamesList) {
        this.em.merge((Object)nurseNamesList);
    }

    public void deleteUserAccount(int userId) {
        Query query = this.em.createQuery("delete from  User where id = :emailAddress ");
        query.setParameter("emailAddress", (Object)userId);
        query.executeUpdate();
    }
}

