/*
 * Decompiled with CFR 0.152.
 */
package com.example.clinic.repository.impl;

import com.example.clinic.model.MessageCenter;
import com.example.clinic.model.nurse;
import com.example.clinic.model.primarydiag;
import com.example.clinic.model.secondary;
import com.example.clinic.model.team;
import com.example.clinic.model.tretary;
import com.example.clinic.repository.MessageCenterRepository;
import java.util.List;
import java.util.Optional;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.transaction.Transactional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Transactional
@Repository
public class MessageCenterRepositoryImpl
implements MessageCenterRepository {
    @Autowired
    EntityManager em;

    public MessageCenter addMessage(MessageCenter messageCenter) {
        return (MessageCenter)this.em.merge((Object)messageCenter);
    }

    public Optional<MessageCenter> getMessage(String emailAddress) {
        TypedQuery query = this.em.createQuery("from MessageCenter where emailAddress = :email AND read = 'notRead' order by id desc", MessageCenter.class);
        query.setParameter("email", (Object)emailAddress);
        List test = query.getResultList();
        if (!test.isEmpty()) {
            return Optional.ofNullable((MessageCenter)test.get(0));
        }
        return Optional.empty();
    }

    public boolean getMessageStatus(String email) {
        TypedQuery query = this.em.createQuery("from MessageCenter where emailAddress = :email And status = true ", MessageCenter.class);
        query.setParameter("email", (Object)email);
        List test = query.getResultList();
        if (!test.isEmpty()) {
            return Optional.ofNullable((MessageCenter)test.get(0)).get().isStatus();
        }
        return false;
    }

    public void updateStatus(String email, int id) {
        Query query = this.em.createQuery("update   MessageCenter set status = false ,read ='read' where emailAddress = :emailAddress AND id =:id");
        query.setParameter("emailAddress", (Object)email);
        query.setParameter("id", (Object)id);
        query.executeUpdate();
    }

    public List<secondary> getSecondryDiagnose() {
        TypedQuery query = this.em.createQuery("from secondary ", secondary.class);
        return query.getResultList();
    }

    public List<team> getPhysicianTeam() {
        TypedQuery query = this.em.createQuery("from team", team.class);
        return query.getResultList();
    }

    public List<nurse> getNursesName() {
        TypedQuery query = this.em.createQuery("from nurse ", nurse.class);
        return query.getResultList();
    }

    public List<tretary> getTeritary() {
        TypedQuery query = this.em.createQuery("from tretary ", tretary.class);
        return query.getResultList();
    }

    public List<primarydiag> getPrimaryDiagnose() {
        TypedQuery query = this.em.createQuery("from primarydiag ", primarydiag.class);
        return query.getResultList();
    }

    public long getUnreadMessageCounts(String name) {
        Query query = this.em.createQuery("SELECT COUNT(*) FROM MessageCenter  where emailAddress = :email AND read = 'notRead'");
        query.setParameter("email", (Object)name);
        return (Long)query.getSingleResult();
    }

    public Optional<MessageCenter> getAllMessages(String name) {
        TypedQuery query = this.em.createQuery("from MessageCenter where emailAddress = :email ", MessageCenter.class);
        query.setParameter("email", (Object)name);
        Optional<MessageCenter> test = query.getResultList().stream().findAny();
        return test;
    }

    public MessageCenter getSingleMesage(String name, int id) {
        TypedQuery query = this.em.createQuery("from MessageCenter where emailAddress = :email AND id =  :id", MessageCenter.class);
        query.setParameter("email", (Object)name);
        query.setParameter("id", (Object)id);
        MessageCenter test = (MessageCenter)query.getSingleResult();
        return test;
    }

    public void updateAllesagesstatus(String name) {
        Query query = this.em.createQuery("update   MessageCenter set status = false ,read ='read' where emailAddress = :emailAddress ");
        query.setParameter("emailAddress", (Object)name);
        query.executeUpdate();
    }
}

