/*
 * Decompiled with CFR 0.152.
 */
package com.example.clinic.controller;

import com.example.clinic.dto.MessageCenterDTO;
import com.example.clinic.dto.UserCreateRequest;
import com.example.clinic.model.MessageCenter;
import com.example.clinic.model.OnBoarding;
import com.example.clinic.model.nurse;
import com.example.clinic.model.primarydiag;
import com.example.clinic.model.secondary;
import com.example.clinic.model.team;
import com.example.clinic.model.tretary;
import com.example.clinic.service.MessageCenterService;
import com.example.clinic.service.RegisterService;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin
public class OnboardView {
    @Autowired
    RegisterService registerService;
    @Autowired
    MessageCenterService messageCenterService;

    @GetMapping(value={"/onboard/view"})
    public List<OnBoarding> getOnboard() {
        return this.registerService.getOnBoard();
    }

    @PostMapping(value={"/message/add"})
    public MessageCenter addMessage(@RequestBody MessageCenterDTO messageCenterDTO) {
        return this.messageCenterService.addMessage(messageCenterDTO);
    }

    @GetMapping(value={"/get/message/not-read"})
    public Optional<MessageCenter> getUnreDMessages() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        return this.messageCenterService.getMessage(authentication.getName());
    }

    @GetMapping(value={"/get/message"})
    public Optional<MessageCenter> getMessagesALL() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        return this.messageCenterService.getMessageALL(authentication.getName());
    }

    @GetMapping(value={"/get/message/{id}"})
    public MessageCenter getSingleMessages(@PathVariable(value="id") int id) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        return this.messageCenterService.getSinglMessage(authentication.getName(), id);
    }

    @GetMapping(value={"/get/message/not-read/counts"})
    public long getunreadMessageCounts() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        return this.messageCenterService.getMessageCounts(authentication.getName());
    }

    @PutMapping(value={"/update/message/status/{id}"})
    public ResponseEntity<?> updateMessageStatus(@PathVariable(value="id") int id) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        this.messageCenterService.getMessageWithStatusUpdate(authentication.getName(), id);
        return ResponseEntity.ok((Object)"updated");
    }

    @PutMapping(value={"/update/all-message/status"})
    public ResponseEntity<?> updateAllMessageStatus() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        this.messageCenterService.AllMessageWithStatusUpdate(authentication.getName());
        return ResponseEntity.ok((Object)"Updated");
    }

    @GetMapping(value={"/get/message/status"})
    public boolean getMessagesStatus(@RequestParam(value="email") String email) {
        return this.messageCenterService.getMessageStatus(email);
    }

    @PutMapping(value={"/update/{userId}/profile"})
    public ResponseEntity<?> updateUserProfile(@PathVariable int userId, @RequestBody UserCreateRequest userCreateRequest) {
        this.messageCenterService.updateUserDetails(userCreateRequest, userId);
        return ResponseEntity.ok((Object)("user update with id : " + userId));
    }

    @GetMapping(value={"primary/diagnose/list"})
    public List<primarydiag> getPriomaryDiagnoseList() {
        return this.messageCenterService.getPrimaryDiagnose();
    }

    @GetMapping(value={"secondary/diagnose/list"})
    public List<secondary> getSecondaryDiagnose() {
        return this.messageCenterService.getSecondaryDiagnose();
    }

    @GetMapping(value={"physician/team/list"})
    public List<team> getPhysicaianTeam() {
        return this.messageCenterService.getPhysicianteam();
    }

    @GetMapping(value={"nurse/names/list"})
    public List<nurse> getnursesNameList() {
        return this.messageCenterService.getNursenames();
    }

    @GetMapping(value={"teritary/list"})
    public List<tretary> getTeritary() {
        return this.messageCenterService.getTeritaryList();
    }
}

